#!/bin/sh

MASTER_PAGE_ACCOUNT_CONF_RESULT_MSG=""
MASTER_PAGE_ACCOUNT_CONF_RESULT_OK=0
MASTER_PAGE_ACCOUNT_CONF_RESULT_ERROR=1

MASTER_PAGE_ACCOUNT_CONF_RESULT_CODE=${MASTER_PAGE_ACCOUNT_CONF_RESULT_ERROR}
MASTER_PAGE_ACCOUNT_CONF_RESULT_ROLLING=0

master_page_account_conf() {
		
	local menu_list="\"${MASTER_PAGE_ACCOUNT_CONF_ITEM_1}\" \"\" \"${MASTER_PAGE_ACCOUNT_CONF_ITEM_2}\" \"\""

	##################################################
	# display menu - cluster setting
	##################################################
	local page_text=`printf "${MASTER_PAGE_ACCOUNT_CONF_TEXT}" "${account_to_be_modified}"`
	tp_menu_ok_cancel \
		"${MASTER_PAGE_ACCOUNT_CONF_TITLE}" \
		"${page_text}" \
		"${MASTER_PAGE_ACCOUNT_CONF_OK_LABEL}" \
		"${MASTER_PAGE_ACCOUNT_CONF_CANCEL_LABEL}" \
		"$menu_list"
		
	# if user choose CANCEL or ESC, roll back to main setting page
	if [ "${TP_MENU_OK_CANCEL_RESULT_CODE}" == "${TP_MENU_OK_CANCEL_RESULT_CANCEL}" ]; then
		MASTER_PAGE_ACCOUNT_CONF_RESULT_CODE=$MASTER_PAGE_ACCOUNT_CONF_RESULT_OK
		MASTER_PAGE_ACCOUNT_CONF_RESULT_ROLLING=-1
		return
	fi
	#debug_print $0 $LINENO "[Account Management] user choose: $TP_MENU_OK_CANCEL_RESULT_SELECT"
	
	##################################################
	# redirect page
	##################################################
	case "${TP_MENU_OK_CANCEL_RESULT_SELECT}" in
		"${MASTER_PAGE_ACCOUNT_CONF_ITEM_1}") # change password
			master_page_ms_change_password
                        return
			;;
		"${MASTER_PAGE_ACCOUNT_CONF_ITEM_2}") # delete account
                        # check if the account you wanna delete is yourself or not
                        local id=`id | awk '{print $2}' | awk -F"[()]" '{ print $2}' | grep "^${account_to_be_modified}$"`
                        if [ "${id}" != "" ]; then
                                dprint "ERROR" "${MASTER_PAGE_ACCOUNT_CONF_CANT_DELETE_YOURSELF}"
                                warning_with_title "${MASTER_PAGE_ACCOUNT_CONF_DELETE_TITLE}" "${MASTER_PAGE_ACCOUNT_CONF_CANT_DELETE_YOURSELF}"
                                MASTER_PAGE_ACCOUNT_CONF_RESULT_CODE=$MASTER_PAGE_ACCOUNT_CONF_RESULT_OK
                                MASTER_PAGE_ACCOUNT_CONF_RESULT_ROLLING=0
                                return
                        fi

                        # check if the account you wanna delete is currently logged in or not
			local logged_in_account=`who | awk '{print $1}' | grep $account_to_be_modified`
			if [ "${logged_in_account}" == "${account_to_be_modified}" ]; then
                                dprint "ERROR" "${MASTER_PAGE_ACCOUNT_CONF_DELETE_LOGGED_IN_ACCOUNT}"
				local msg=`printf "${MASTER_PAGE_ACCOUNT_CONF_DELETE_LOGGED_IN_ACCOUNT}" "${account_to_be_modified}"`
				warning_with_title "${MASTER_PAGE_ACCOUNT_CONF_DELETE_TITLE}" "$msg"
				MASTER_PAGE_ACCOUNT_CONF_RESULT_CODE=$MASTER_PAGE_ACCOUNT_CONF_RESULT_OK
				MASTER_PAGE_ACCOUNT_CONF_RESULT_ROLLING=0
				return
			fi
			
                        tp_yesno "${MASTER_PAGE_ACCOUNT_CONF_DELETE_TITLE}" "${MASTER_PAGE_ACCOUNT_CONF_DELETE_MSG}"
			if [ "${TP_YESNO_RESULT_SELECT}" == "${TP_YESNO_RESULT_YES}" ]; then
                                dprint "DEBUG" "Delete account:${account_to_be_modified}"
				local ret=`/usr/sbin/userdel -r "${account_to_be_modified}"`
			fi
			;;
	esac
	
	MASTER_PAGE_ACCOUNT_CONF_RESULT_CODE=$MASTER_PAGE_ACCOUNT_CONF_RESULT_OK
	MASTER_PAGE_ACCOUNT_CONF_RESULT_ROLLING=0
}
